#include <windows.h>											// Header File For Windows
#include <stdlib.h>
#include <stdio.h>
#include <gl\gl.h>												// Header File For The OpenGL32 Library
#include <gl\glu.h>												// Header File For The GLu32 Library
#include <gl\glaux.h>											// Header File For The GLaux Library

#include "wglext.h"		//WGL extensions
#include "glext.h"		//GL extensions

#include <math.h>

//#include <gl\glut.h>

#include "NeHeGL.h"												// Header File For NeHeGL
#include "Utils.h"
#include "CTaskList.h"
#include "CAltTabData.h"
#include "MyAlt-Tab.h"

#include "WinFunctions.h"
#include "Fonts.h"

//#include "CTransFX.h"

#pragma comment( lib, "opengl32.lib" )							// Search For OpenGL32.lib While Linking
#pragma comment( lib, "glu32.lib" )								// Search For GLu32.lib While Linking
#pragma comment( lib, "glaux.lib" )								// Search For GLaux.lib While Linking
//#pragma comment( lib, "glut32.lib" )							// Search For Glut.lib While Linking
//#pragma comment( lib, "ComCtl32.lib" )								// Search For GLaux.lib While Linking
//#include <commctrl.h>

#ifndef CDS_FULLSCREEN											// CDS_FULLSCREEN Is Not Defined By Some
#define CDS_FULLSCREEN 4										// Compilers. By Defining It This Way,
#endif															// We Can Avoid Errors

#define DYN_TEXTURE_SIZE	1024

#define FONT_HEIGHT		18

GL_Window*	g_window;
Keys*		g_keys;

// User Defined Variables
float		angle;												// Used To Rotate The Triangles
int			rot1, rot2;	

// Process List
CAltTabData *procList;

// Transition Effect
//CTransFX transFX;
#define FX_DURATION	400
#define FX_NONE		0
#define FX_RIGHT	-1
#define FX_LEFT		1
bool  fxDone = true;
float fxTargetAngle = 0.0;
int	  fxDirection	= FX_NONE;

// Text
bool usePrettyText	= true;
GLuint textBkTex;

// Background Texture
bool updtBackgroundTexture = false;
UINT_PTR UTTimerID = NULL;

// Texture Filtering
GLfloat maxAnisotropy = 1.0f;




void CALLBACK UpdtTexTimerProc( 
    HWND hwnd,        // handle to window for timer messages 
    UINT message,     // WM_TIMER message 
    UINT idTimer,     // timer identifier 
    DWORD dwTime)     // current system time 
{ 

	RECT r;		
	GetWindowRect(hwnd, &r);

	ShowWindow(hwnd, SW_HIDE);
	Sleep(50);
	UpdateBackgroundTexture(GL_TEXTURE_RECTANGLE, &procList->m_backTexture, r.left, r.top, r.right - r.left, r.bottom - r.top);	
	ShowWindow(hwnd, SW_SHOW);


	return;
} 

BOOL Initialize (GL_Window* window, Keys* keys)					// Any GL Init Code & User Initialiazation Goes Here
{
	g_window	= window;
	g_keys		= keys;

	// Check for all working conditions

	//Check for OS version (Windows XP+)
	if(CheckOSVersion() == FALSE){
		return FALSE;
	}

	//Check for GL_EXT_texture_rectangle or GL_NV_texture_rectangle
	
	if(!IsExtensionSupported("GL_EXT_texture_rectangle") &&	!IsExtensionSupported("GL_NV_texture_rectangle")){
		return FALSE;
	}

	// OpenGL Initialization
	glClearColor (0.0f, 0.0f, 0.0f, 0.5f);						// Black Background
	glClearDepth (1.0f);										// Depth Buffer Setup
	glDepthFunc (GL_LEQUAL);									// The Type Of Depth Testing (Less Or Equal)
	glEnable (GL_DEPTH_TEST);									// Enable Depth Testing
	glShadeModel (GL_SMOOTH);									// Select Smooth Shading
	glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);			// Set Perspective Calculations To Most Accurate
	
	glEnable(GL_CULL_FACE);					
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	// Enables polygon smooth ( Antialiasing ) w/o muiltisample.
	//glHint (GL_LINE_SMOOTH_HINT, GL_NICEST);	
	//glHint (GL_POLYGON_SMOOTH_HINT, GL_NICEST);	
	//glEnable(GL_LINE_SMOOTH);
	//glEnable(GL_POLYGON_SMOOTH);

	// Initialize fonts
	InitFont(g_window->hDC, "Tahoma", FONT_HEIGHT, FW_HEAVY, false);

	//InitCommonControls();

		

	// Initialize the processes information
	
	procList = new CAltTabData();

	RECT r;	
	GetWindowRect(g_window->hWnd, &r);
	
	//AnimateWindow(g_window->hWnd, 1, AW_BLEND | AW_HIDE);
	ShowWindow(g_window->hWnd, SW_HIDE);

	//char str[512] = "";
	//sprintf(str, "%d, %d, %d, %d", r.left, r.top, r.right - r.left, r.bottom - r.top);
    //MessageBox(NULL, str, "info", MB_OK);
	
	CreateBackgroundTexture(GL_TEXTURE_RECTANGLE, &procList->m_backTexture, r.left, r.top, r.right - r.left, r.bottom - r.top);
		
	//sprintf(str, "%d, %x", procList->m_backTexture, &procList->m_backTexture);
 //   MessageBox(NULL, str, "info", MB_OK);

	ShowWindow(g_window->hWnd, SW_SHOW);
	//AnimateWindow(g_window->hWnd, 1, AW_BLEND);
	SetForegroundWindow(g_window->hWnd);

	// Start Of User Initialization
	angle		= 0.0f;											// Set Starting Angle To Zero

/*	// Load the shadow frame texture
	if(!LoadGLTexture(GL_TEXTURE_2D, &textBkTex, "data/bg.bmp")){
		MessageBox(NULL, "No Text Background texture", "Error", MB_ICONERROR | MB_OK);
	}
*/

	// Texture filtering
	glGetFloatv(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT, &maxAnisotropy);

    // Set Background Texture update interval (5 seconds). Testing only, buggy effect.
	if(updtBackgroundTexture){
		// set the timer func
		UTTimerID = SetTimer(g_window->hWnd, NULL, 5000, UpdtTexTimerProc);
	}


	return TRUE;												// Return TRUE (Initialization Successful)
}

void Deinitialize (void)										// Any User DeInitialization Goes Here
{

	if(updtBackgroundTexture){
		// unset the timer func
		KillTimer(g_window->hWnd, UTTimerID);
	}

	glDeleteTextures(1, &procList->m_backTexture);
	//glDeleteTextures(1, textBkTex);
	delete procList;



	// Destroy fonts
	DestroyFont();
}

void Update (DWORD milliseconds)								// Perform Motion Updates Here
{
	if(!fxDone){
		procList->m_displayAngle += (float)fxDirection * ((milliseconds * procList->m_unitAngle) / (float)FX_DURATION);		
		if(((fxDirection == FX_LEFT) && (procList->m_displayAngle >= fxTargetAngle))
			||
		   ((fxDirection == FX_RIGHT) && (procList->m_displayAngle <= fxTargetAngle))){
			procList->m_displayAngle = fxTargetAngle;
			fxTargetAngle = 0.0;
			fxDirection = FX_NONE;
			fxDone = true;
		} 
	}

	if (g_keys->keyDown [VK_ESCAPE] == TRUE)					// Is ESC Being Pressed?
	{
		TerminateApplication (g_window);						// Terminate The Program
	}

	if (g_keys->keyDown [VK_RETURN] == TRUE)					// Is ENTER Being Pressed?
	{
		CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
				
		SwitchToWindow(cti.taskPv);

		TerminateApplication (g_window);						// Terminate The Program
	}

	if (g_keys->keyDown [VK_F1] == TRUE)						// Is F1 Being Pressed?
	{
		ToggleFullscreen (g_window);							// Toggle Fullscreen Mode
	}

	if (g_keys->keyDown ['T'] == TRUE)						// Is F1 Being Pressed?
	{
		g_keys->keyDown ['T'] = FALSE;
		usePrettyText = !usePrettyText;
	}

	if(g_keys->keyDown[VK_LEFT]){		
		if(procList->m_nTasks > 1 && fxDone){			
			procList->m_selectedTaskIdx = (procList->m_selectedTaskIdx+1) % procList->m_nTasks;
			
			fxTargetAngle = procList->m_displayAngle + procList->m_unitAngle;
			fxDirection = FX_LEFT;
			fxDone = false;

			//procList->m_displayAngle += procList->m_unitAngle;//procList->m_selectedTaskIdx * procList->m_unitAngle;
			//procList->m_displayAngle = (procList->m_displayAngle > 360.0f) ? 0 : procList->m_displayAngle;

			CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
			
			//char str[1024] = "";
			//sprintf(str, "%d - %d",cti.taskWidth, cti.taskHeight);
			SetWindowText(g_window->hWnd, cti.taskText);	
			
			g_keys->keyDown[VK_LEFT] = FALSE;

			procList->calculateDrawingOrder();

		}
	}

	if(g_keys->keyDown[VK_RIGHT]){
		
		if(procList->m_nTasks > 1 && fxDone){		

			if(procList->m_selectedTaskIdx == 0){
				procList->m_selectedTaskIdx = procList->m_nTasks - 1;
			} else {
				procList->m_selectedTaskIdx = (procList->m_selectedTaskIdx-1);
			}
	        
			fxTargetAngle = procList->m_displayAngle - procList->m_unitAngle;
			fxDirection = FX_RIGHT;
			fxDone = false;

			//procList->m_displayAngle -= procList->m_unitAngle;//procList->m_selectedTaskIdx * procList->m_unitAngle;				
			//procList->m_displayAngle = (procList->m_displayAngle > 360.0f) ? 0 : procList->m_displayAngle;

			CTaskInfo cti = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
			
			//char str[1024] = "";
			//sprintf(str, "%d - %s",procList->m_selectedTaskIdx, cti.taskText);
			SetWindowText(g_window->hWnd, cti.taskText);	

			g_keys->keyDown[VK_RIGHT] = FALSE;

			procList->calculateDrawingOrder();
		}
		
	}
	

}

void DrawTasks(){
	
	glDisable(GL_CULL_FACE);

	glPushMatrix();
	//glTranslatef (0.0f, 0.0f, -10.0f);
	//glRotatef (-90.0, 1.0f, 0.0f, 0.0f);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	
	for (int t = 0; t< procList->m_nTasks; t++)								// 2 Passes
	{	
		glRotatef(360.0 - procList->m_drawOrder[t]*procList->m_unitAngle,0.0f,1.0f,0.0f);						// Rotate 90 Degrees On The Y-Axis		
		glTranslatef (0.0f, 0.0f, procList->m_displacement);

		float c = (procList->m_drawOrder[t]+1)*procList->m_unitAngle / 360.0;
		
		if(procList->m_drawOrder[t] == procList->m_selectedTaskIdx){
			glColor4f (1.0, 1.0, 1.0, 0.95);	
		} else {
			glColor4f (1.0, 1.0, 1.0, 0.75);	
			//glDepthMask(GL_FALSE);
		}
		CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_drawOrder[t]);

		//glutSolidSphere(0.5, 30,30);		
		glEnable(GL_TEXTURE_RECTANGLE);
		glBindTexture(GL_TEXTURE_RECTANGLE, procList->m_taskTextures[procList->m_drawOrder[t]]);		
		glTexParameterfv(GL_TEXTURE_RECTANGLE, GL_TEXTURE_MAX_ANISOTROPY_EXT, &maxAnisotropy);


		int ww = tInfo.taskWidth;
		int hh = tInfo.taskHeight;

		float ratio = (float)ww / (float)hh;

		float ws = SHAPE_WIDTH;
		float hs = SHAPE_HEIGHT;

		/*if(tInfo.taskIconic){
			ws = hs = 0.5;
		}*/

		if(ratio >= 1){
			hs /= ratio;
		} else {
			ws *= ratio;
		}

		glBegin (GL_QUADS);								// Begin Drawing Triangles
			glTexCoord2f(0.0, hh);   glVertex3f( -ws, hs, 0.0f);
			glTexCoord2f(0.0, 0.0);  glVertex3f(-ws,-hs, 0.0f);
			glTexCoord2f( ww, 0.0);  glVertex3f( ws,-hs, 0.0f);
			glTexCoord2f( ww, hh);   glVertex3f( ws,hs, 0.0f);
		glEnd ();											// Done Drawing Triangles
		

		glDisable(GL_TEXTURE_RECTANGLE);

		//glDepthMask(GL_TRUE);
		glTranslatef (0.0f, 0.0f, -procList->m_displacement);

		glRotatef(-(360.0 - procList->m_drawOrder[t]*procList->m_unitAngle),0.0f,1.0f,0.0f);	
	}
	
	glDisable(GL_BLEND);
	glPopMatrix();

	glEnable(GL_CULL_FACE);
	


	glFlush ();													// Flush The GL Rendering Pipeline

	return;
}
//#include "gl/glut.h"

void DrawTaskText(){

	// Fonts
/*	
	RECT r; GetClientRect(g_window->hWnd, &r);

HFONT font = CreateFont(20, 10, 0, 0, FW_BOLD, 0, 0, 0,
  ANSI_CHARSET, OUT_DEVICE_PRECIS, 
  CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, DEFAULT_PITCH, "Tahoma");

SelectObject(g_window->hDC, font);



SetBkMode(g_window->hDC, TRANSPARENT);


CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_selectedTaskIdx);
int len = strlen(tInfo.taskText);
WCHAR szText[MAX_TEXT_LENGHT] = L"";
if (!InternalGetWindowText(tInfo.task, szText, MAX_TEXT_LENGHT)){
			InternalGetWindowText(tInfo.taskPv, szText, MAX_TEXT_LENGHT);
}
DrawShadowText(g_window->hDC, szText, len, &r,DT_BOTTOM | DT_CENTER | DT_SINGLELINE | DT_NOPREFIX | DT_END_ELLIPSIS, RGB(255,255,255), RGB(0,0,0), 2, 2);
//DrawText(g_window->hDC, tInfo.taskText, (len <= 50)?len:50, &r, DT_BOTTOM | DT_CENTER | DT_SINGLELINE );


DeleteObject(font); 

*/
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();		
		//glLoadIdentity ();

			CTaskInfo tInfo = procList->m_tasks->getTask(procList->m_selectedTaskIdx);

			char txt[65] = "";

			strncpy(txt, tInfo.taskText, 55*sizeof(char));
			if(strlen(tInfo.taskText) > 55){
				txt[51] = txt[52] = txt[53] = '.';
				txt[54] = '\0';
			}

			if(!usePrettyText){

				glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

				glBegin (GL_QUAD_STRIP);								// Begin Drawing Triangles

					glColor4ub(214, 219, 191,0);
					glVertex3f(  0,  0, ZNEAR_2D_FIX);
					glVertex3f(  0, 25, ZNEAR_2D_FIX);				

					glColor4ub(214, 219, 191,245);
					glVertex3f( 15,  0, ZNEAR_2D_FIX);
					glVertex3f( 15, 25, ZNEAR_2D_FIX);				

					glVertex3f(WindowWidth - 15,  0, ZNEAR_2D_FIX);
					glVertex3f(WindowWidth - 15, 25, ZNEAR_2D_FIX);				

					glColor4ub(214, 219, 191,0);
					glVertex3f(WindowWidth,  0, ZNEAR_2D_FIX);
					glVertex3f(WindowWidth, 25, ZNEAR_2D_FIX);				
					
				glEnd ();											// Done Drawing Triangles
				
				glDisable(GL_BLEND);

				//set the text color for the actual text render
				glColor4ub(107, 109, 95,250);
				glRasterPos3f(15.0,FONT_HEIGHT - 0.5, ZNEAR_2D_FIX);
				glDraw2DText(txt);
			
			} else {
					
				//Pretty Text -- Good but requires to much CPU time				
				glEnable(GL_BLEND);
				glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

				glColor4f(0.25, 0.25, 0.25,0.25);

				glRasterPos3f(25+1.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+4.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT-1.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);

				glRasterPos3f(25+1.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+4.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+4.0,FONT_HEIGHT+2, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT-1.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);

				
				glColor4f(0.1, 0.1, 0.1,0.65);			
				glRasterPos3f(25+3.0,FONT_HEIGHT, ZNEAR_2D_FIX);			
				glDraw2DText(txt);
				glRasterPos3f(25+2.0,FONT_HEIGHT+2.0, ZNEAR_2D_FIX);			
				glDraw2DText(txt);

				glDisable(GL_BLEND);
				//set the text color and position for the actual text render
				glColor4f(1.0, 1.0, 1.0,1.0);
				glRasterPos3f(25+2.0,FONT_HEIGHT - 0.5, ZNEAR_2D_FIX);
				glDraw2DText(txt);

/*				// Make a shadow frame around the main window
				glEnable(GL_TEXTURE_2D);
				glBindTexture(GL_TEXTURE_2D, textBkTex);
				glEnable(GL_BLEND);
				glBlendFunc(GL_ZERO, GL_SRC_COLOR);
				glColor4f(1.0, 1.0, 1.0,1.0);
				glBegin (GL_QUADS);								// Begin Drawing Triangles

					glTexCoord2f(0.0f, 0.0f); 
					glVertex3f(  0, WindowHeight, ZNEAR_2D_FIX); 
					glTexCoord2f(1.0f, 0.0f); 
					glVertex3f(WindowWidth, WindowHeight, ZNEAR_2D_FIX);				
					glTexCoord2f(1.0f, 1.0f); 
					glVertex3f(WindowWidth,  0, ZNEAR_2D_FIX);
					glTexCoord2f(0.0f, 1.0f); 
					glVertex3f(  0,  0, ZNEAR_2D_FIX);									
					
				glEnd ();											// Done Drawing Triangles
				
				glDisable(GL_BLEND);
*/

			}
		
			
			
						
			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glFlush ();													// Flush The GL Rendering Pipeline

	return;
}


/* compute scale factor for window->object space transform */
/* could use gluUnProject(), but probably too much trouble */
void
computescale(GLfloat *sx, GLfloat *sy)
{
  enum {XORG, YORG, WID, HT};
  GLint viewport[4];
  glGetIntegerv(GL_VIEWPORT, viewport);

  *sx = (float)WindowWidth/viewport[WID];
  *sy = (float)WindowHeight/viewport[WID];
}

void Draw (void)
{
	if(procList->m_nTasks == 0){
		g_keys->keyDown[VK_ESCAPE] = TRUE;
		return;
	}

	glClearColor(0.0f, 0.0f, 0.3f, 0.0f);						// Black Background	
	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);		// Clear Screen And Depth Buffer	
	glLoadIdentity ();											// Reset The Modelview Matrix
		
	static float displacement = SHAPE_WIDTH*2 + 1.5*procList->m_displacement;
	glTranslatef (0.0f, 0.0f, -(displacement));							// Translate 6 Units Into The Screen


	glRotatef (procList->m_displayAngle, 0.0f, 1.0f, 0.0f);						// Rotate On The Y-Axis By angle
	



	//glRotatef (180.0, 0.0f, 1.0f, 0.0f);

	//Render to texture stuff
	glEnable(GL_TEXTURE_RECTANGLE);
	glBindTexture(GL_TEXTURE_RECTANGLE, procList->m_backTexture);
		
	//glReadPixels(	
	setOrthographicProjection(WindowWidth, WindowHeight, true);
		glPushMatrix();
			
		float zz = -(zFar-zNear);
						
			//float ww = (float)WindowWidth/1024.0;
			//float hh = (float)WindowHeight/1024.0;
			//glEnable(GL_BLEND);
			glColor4f(1.0, 1.0, 1.0,0.5);
			glBegin(GL_QUADS);			

				glTexCoord2f(0.0, WindowHeight);  glVertex3f(0, 0, zz);
				glTexCoord2f(0.0, 0.0);  glVertex3f(0, WindowHeight, zz);
				glTexCoord2f(WindowWidth, 0.0);  glVertex3f(WindowWidth, WindowHeight, zz);
				glTexCoord2f(WindowWidth, WindowHeight);  glVertex3f(WindowWidth, 0, zz);
			glEnd();
			//glDisable(GL_BLEND);
			
			glColor4f(1.0, 1.0, 1.0,1.0);
		glPopMatrix();
	resetPerspectiveProjection();

	glDisable(GL_TEXTURE_RECTANGLE);

	// Start accumulation stuff

	int i, j;
    int min, max;
    int count;
    GLfloat invx, invy;
    GLfloat scale, dx, dy;

    
      min = -1;
      max = -min + 0;
      count = 2;//-2 * min + 1;
      count *= count;

      /* uniform scaling, less than one pixel wide */
      scale = -1.5f/min;

      computescale(&invx, &invy);

      glClear(GL_ACCUM_BUFFER_BIT);

      for(j = min; j < max; j++) {
        for(i = min; i < max; i++) {
          dx = invx * scale * i;
          dy = invy * scale * j;
		  glViewport (-dx, -dy, WindowWidth+dx, WindowHeight+dy);	
		  
          /*glMatrixMode(GL_PROJECTION);
          glLoadIdentity();
          glFrustum(-WindowWidth/2.0f + dx, 
                     -WindowHeight/2.0f + dy, 
                    WindowWidth/2.0f + dx, 
                    WindowHeight/2.0f + dy, 
                    zNear, zFar); 
          glMatrixMode(GL_MODELVIEW);*/
          DrawTasks();
          glAccum(GL_ACCUM, 1.f/count);
        }
      }
    glAccum(GL_RETURN, 1.f);
	

	// End accumulation stuff

	//static float a = -10.0;
	

	DrawTaskText();

	
	
	glFlush ();													// Flush The GL Rendering Pipeline
}
